<?php

function mod_s4u_slider($module_id){

    $inCore = cmsCore::getInstance();
	$inDB   = cmsDatabase::getInstance();
    $cfg    = $inCore->loadModuleConfig($module_id);

    cmsCore::loadModel('video');
    $model = cms_model_video::initModel();

	if($model->config['is_seo_url']){

		if($cfg['cat'] == 'auto'){
			$seolink = cmsCore::request('cat_link', 'str', '');
		} else {
			$cat_id  = $cfg['cat_id'];
		}


	} else {

		if($cfg['cat'] == 'auto'){
			$cat_id  = cmsCore::request('cat_id', 'int', 0);
		} else {
			$cat_id  = $cfg['cat_id'];
		}

	}

	if($cat_id){
		$cat = $model->getCategory($cat_id);
	}
	if($seolink){
		$cat = $model->getCategoryByLink($seolink);
	}

	if($cat) {
		if(!cmsCore::checkUserAccess('video', $cat['id'])) { return false; }

		$model->whereThisAndNestedCats($cat['NSLeft'], $cat['NSRight']);
	}

	if($cfg['rubric_id']){
		$model->whereRubricIs($cfg['rubric_id']);
	}


	$model->whereOnlyConverted();
	$model->whereOnlyPublicMovie();
	if($cfg['only_adult']) { $model->whereIsAdult(); }

	$inDB->orderBy($cfg['type'], 'DESC');
	$inDB->limitPage(1, $cfg['count']);

	$items = $model->getMovies(false);

	if(!$items) { return false; }

    $smarty = $inCore->initSmarty('modules', 'mod_s4u_slider.tpl');
    $smarty->assign('cfg', $cfg);
	$smarty->assign('module_id', $module_id);
    $smarty->assign('items_slider', $items);
    $smarty->display('mod_s4u_slider.tpl');

    return true;

}
?>